/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.admin.property.appspace;

import filenet.vw.api.VWApplicationSpaceDefinition;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.admin.property.appspace.VWRolePropertyPanel;
import filenet.vw.toolkit.admin.property.appspace.VWRolesTableModel;
import filenet.vw.toolkit.admin.resources.VWResource;
import filenet.vw.toolkit.utils.VWAccessibilityHelper;
import filenet.vw.toolkit.utils.VWDataDictionary;
import filenet.vw.toolkit.utils.VWSessionInfo;
import filenet.vw.toolkit.utils.VWSplitPane;
import filenet.vw.toolkit.utils.VWStringUtils;
import filenet.vw.toolkit.utils.dialog.VWMessageDialog;
import filenet.vw.toolkit.utils.table.VWTable;
import filenet.vw.toolkit.utils.table.VWTableCellEditor;
import filenet.vw.toolkit.utils.table.VWTableCellRenderer;
import filenet.vw.toolkit.utils.uicontrols.border.IVWToolbarBorderActionListener;
import filenet.vw.toolkit.utils.uicontrols.border.VWToolbarBorder;
import filenet.vw.toolkit.utils.uicontrols.border.VWToolbarBorderActionEvent;
import filenet.vw.toolkit.utils.uicontrols.border.VWToolbarBorderClientActionEvent;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.util.Locale;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;

public class VWRolesPanel
extends JPanel
implements TableModelListener,
ListSelectionListener,
IVWToolbarBorderActionListener {
    private VWSessionInfo m_sessionInfo = null;
    private VWApplicationSpaceDefinition m_appSpaceDef = null;
    private boolean m_bIsModified = false;
    private VWToolbarBorder m_rolesToolBar = null;
    private VWTable m_roleTable = null;
    private VWRolesTableModel m_roleTableModel = null;
    private VWRolePropertyPanel m_rolePropertyPanel = null;
    private static final double s_defaultHSplitRatio = 0.25;
    private static final double s_defaultHSplitRatio_bidi = 0.7;

    public VWRolesPanel(VWSessionInfo sessionInfo, VWDataDictionary dataDictionary) {
        this(sessionInfo, dataDictionary, null);
    }

    public VWRolesPanel(VWSessionInfo sessionInfo, VWDataDictionary dataDictionary, VWRolePropertyPanel rolePropertyPanel) {
        this.m_sessionInfo = sessionInfo;
        this.createControls(dataDictionary, rolePropertyPanel);
        this.onSelectedRole();
    }

    public void setApplicationSpace(VWApplicationSpaceDefinition appSpaceDef) {
        this.m_appSpaceDef = appSpaceDef;
        this.m_roleTableModel.setApplicationSpaceDefinition(appSpaceDef);
        this.setEnabled(this.m_appSpaceDef != null);
        if (this.m_roleTableModel.getRowCount() > 0) {
            this.m_roleTable.setRowSelectionInterval(0, 0);
        }
    }

    public VWApplicationSpaceDefinition getApplicationSpace() {
        return this.m_appSpaceDef;
    }

    public void setEnabled(boolean bEnabled) {
        int nButtonState = 2;
        int nButtons = Integer.MAX_VALUE;
        this.m_rolesToolBar.clientActionPerformed(new VWToolbarBorderClientActionEvent(this.m_rolesToolBar.getClientPanel(), nButtonState, nButtons));
        if (bEnabled) {
            nButtonState = 1;
            nButtons = 16;
            if (this.m_roleTable.getSelectedRow() != -1) {
                nButtons |= 0x10000040;
            }
            this.m_rolesToolBar.clientActionPerformed(new VWToolbarBorderClientActionEvent(this.m_rolesToolBar.getClientPanel(), nButtonState, nButtons));
        }
        this.m_roleTable.setEnabled(bEnabled);
        this.m_rolePropertyPanel.setEnabled(bEnabled && this.m_roleTableModel.getRowCount() > 0);
    }

    public boolean isModified() {
        this.stopEditing();
        if (this.m_roleTableModel != null && this.m_roleTableModel.isModified()) {
            return true;
        }
        if (this.m_rolePropertyPanel != null && this.m_rolePropertyPanel.isModified()) {
            return true;
        }
        return this.m_bIsModified;
    }

    public void resetModifiedFlag() {
        if (this.m_roleTableModel != null) {
            this.m_roleTableModel.resetModifiedFlag();
        }
        if (this.m_rolePropertyPanel != null) {
            this.m_rolePropertyPanel.resetModifiedFlag();
        }
        this.m_bIsModified = false;
    }

    public String[] getModifiedQueueNames() {
        if (this.m_rolePropertyPanel != null) {
            return this.m_rolePropertyPanel.getModifiedQueueNames();
        }
        return null;
    }

    public void handleAppSpaceChangeEvent(VWApplicationSpaceDefinition changedAppSpaceDef) {
        if (this.m_appSpaceDef != null && changedAppSpaceDef != null && VWStringUtils.compare(changedAppSpaceDef.getName(), this.m_appSpaceDef.getName()) == 0) {
            this.stopEditing();
            int nRow = this.m_roleTable.getSelectedRow();
            this.m_appSpaceDef = changedAppSpaceDef;
            this.setApplicationSpace(this.m_appSpaceDef);
            if (nRow == this.m_roleTable.getSelectedRow()) {
                this.m_roleTable.clearSelection();
            }
            if (nRow != -1 && nRow < this.m_roleTableModel.getRowCount()) {
                this.m_roleTable.setRowSelectionInterval(nRow, nRow);
            }
        }
    }

    public void tableChanged(TableModelEvent event) {
        switch (event.getType()) {
            case -1: 
            case 1: {
                int nRow = event.getLastRow();
                if (nRow < 0) {
                    nRow = 0;
                }
                if (nRow > this.m_roleTable.getRowCount() - 1) {
                    nRow = this.m_roleTable.getRowCount() - 1;
                }
                if (nRow == -1) {
                    return;
                }
                if (nRow == this.m_roleTable.getSelectedRow()) {
                    this.m_roleTable.clearSelection();
                }
                this.m_roleTable.setRowSelectionInterval(nRow, nRow);
                break;
            }
            case 0: {
                if (event.getColumn() != 0) break;
                this.onSelectedRole();
            }
        }
    }

    public void valueChanged(ListSelectionEvent event) {
        try {
            if (event.getValueIsAdjusting()) {
                return;
            }
            if (event.getSource().equals(this.m_roleTable.getSelectionModel())) {
                this.onSelectedRole();
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void toolbarBorderActionPerformed(VWToolbarBorderActionEvent event) {
        try {
            this.stopEditing();
            if (event.getSource() == this.m_rolesToolBar) {
                switch (event.getID()) {
                    case 16: {
                        this.m_roleTableModel.addNewRole();
                        break;
                    }
                    case 64: {
                        int nRowIndex = this.m_roleTable.getSelectedRow();
                        if (nRowIndex == -1) {
                            return;
                        }
                        this.m_roleTableModel.copyRoleAtIndex(nRowIndex);
                        break;
                    }
                    case 0x10000000: {
                        int nRowIndex = this.m_roleTable.getSelectedRow();
                        if (nRowIndex == -1) {
                            return;
                        }
                        this.m_roleTableModel.deleteRoleAtIndex(nRowIndex);
                        break;
                    }
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            VWMessageDialog.showOptionDialog(this.m_sessionInfo.getParentFrame(), ex.getLocalizedMessage(), 1);
        }
    }

    protected void stopEditing() {
        if (this.m_roleTable != null) {
            this.m_roleTable.stopEditing();
        }
        if (this.m_rolePropertyPanel != null) {
            this.m_rolePropertyPanel.stopEditing();
        }
    }

    protected void releaseResources() {
        if (this.m_rolesToolBar != null) {
            this.m_rolesToolBar.releaseResources();
            this.m_rolesToolBar = null;
        }
        if (this.m_roleTable != null) {
            this.m_roleTable.removeAll();
            this.m_roleTable = null;
        }
        if (this.m_roleTableModel != null) {
            this.m_roleTableModel.releaseResources();
            this.m_roleTableModel = null;
        }
        if (this.m_rolePropertyPanel != null) {
            this.m_rolePropertyPanel.releaseResources();
            this.m_rolePropertyPanel = null;
        }
        this.m_sessionInfo = null;
        this.m_appSpaceDef = null;
        this.removeAll();
    }

    private void createControls(VWDataDictionary dataDictionary, VWRolePropertyPanel rolePropertyPanel) {
        try {
            this.setLayout(new BorderLayout());
            this.setBorder(BorderFactory.createEmptyBorder(6, 6, 6, 6));
            JPanel leftPanel = this.createRoleTablePanel();
            this.m_rolePropertyPanel = rolePropertyPanel != null ? rolePropertyPanel : new VWRolePropertyPanel(this.m_sessionInfo, dataDictionary);
            ComponentOrientation compOrientation = ComponentOrientation.getOrientation(Locale.getDefault());
            VWSplitPane splitPane = null;
            if (compOrientation.isLeftToRight()) {
                splitPane = new VWSplitPane(1, leftPanel, this.m_rolePropertyPanel);
                splitPane.setDividerLocation(0.25);
            } else {
                splitPane = new VWSplitPane(1, this.m_rolePropertyPanel, leftPanel);
                splitPane.setDividerLocation(0.7);
            }
            splitPane.setResizeWeight(0.25);
            this.add((Component)splitPane, "Center");
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private JPanel createRoleTablePanel() {
        try {
            JPanel roleTablePanel = new JPanel(new BorderLayout());
            roleTablePanel.setBorder(BorderFactory.createEmptyBorder(6, 6, 6, 6));
            this.m_rolesToolBar = new VWToolbarBorder(VWResource.Roles, 0x10000050, VWResource.RolesDescription);
            this.m_rolesToolBar.setToolbarBackground(this.getBackground());
            this.m_rolesToolBar.addToolbarBorderActionNotifier(this);
            VWAccessibilityHelper.setAccessibility(this.m_rolesToolBar, this, VWResource.Roles, VWResource.RolesDescription);
            JPanel childPanel = this.m_rolesToolBar.getClientPanel();
            childPanel.setLayout(new BorderLayout());
            this.m_roleTableModel = new VWRolesTableModel(this.m_sessionInfo);
            this.m_roleTableModel.addTableModelListener(this);
            this.m_roleTable = new VWTable(this.m_roleTableModel);
            this.m_roleTable.setRowSelectionAllowed(true);
            this.m_roleTable.getSelectionModel().setSelectionMode(0);
            this.m_roleTable.getSelectionModel().addListSelectionListener(this);
            this.m_roleTable.setShowGrid(false);
            this.m_roleTable.setTableHeader(null);
            this.m_roleTable.setRowHeight(26);
            this.m_roleTable.setDefaultRenderer(String.class, new VWTableCellRenderer());
            this.m_roleTable.setDefaultEditor(String.class, new VWTableCellEditor(new JTextField()));
            VWAccessibilityHelper.setAccessibility(this.m_roleTable, this, VWResource.RoleTable, VWResource.RoleTable);
            VWAccessibilityHelper.setLabelFor(new JLabel(VWResource.Roles), this.m_roleTable);
            childPanel.add((Component)new JScrollPane(this.m_roleTable), "Center");
            roleTablePanel.add((Component)this.m_rolesToolBar, "Center");
            return roleTablePanel;
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            return null;
        }
    }

    private void onSelectedRole() {
        try {
            int nRowIndex = this.m_roleTable.getSelectedRow();
            int nButtons = 0x10000040;
            if (nRowIndex == -1) {
                this.m_rolesToolBar.clientActionPerformed(new VWToolbarBorderClientActionEvent(this.m_rolesToolBar.getClientPanel(), 2, nButtons));
            } else {
                this.m_rolesToolBar.clientActionPerformed(new VWToolbarBorderClientActionEvent(this.m_rolesToolBar.getClientPanel(), 1, nButtons));
            }
            if (this.m_rolePropertyPanel != null) {
                this.m_rolePropertyPanel.stopEditing();
                if (this.m_rolePropertyPanel.isModified()) {
                    this.m_bIsModified = true;
                }
                this.m_rolePropertyPanel.setRoleDefinition(this.m_roleTableModel.getRowItemAt(nRowIndex));
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }
}

